<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Crypto Payment</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <script src="https://cdn.tailwindcss.com"></script>
  <script src="https://cdn.jsdelivr.net/npm/qrcode/build/qrcode.min.js"></script>
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen">

  <div class="bg-white shadow-lg rounded-2xl p-6 max-w-lg w-full text-center">
    <h1 class="text-xl font-semibold text-gray-800 mb-1">Pay With Blockchain </h1>
    <div class="text-3xl font-bold text-green-600 mb-4">$100</div>

    <!-- Countdown -->
    <div class="mb-6">
      <p class="text-gray-600 text-sm">Please complete the payment within:</p>
      <div id="timer" class="text-3xl font-mono text-red-600 mt-2">15:00</div>
    </div>

    <!-- Crypto Selector -->
    <div class="mb-6 text-left">
      <label for="cryptoSelect" class="block text-sm font-medium text-gray-700">Choose a cryptocurrency:</label>
      <select id="cryptoSelect" class="mt-2 w-full p-2 border rounded-md">
        <option value="btc">Bitcoin</option>
        <option value="eth">Ethereum</option>
        <option value="usdt">USDT (TRC20)</option>
        <option value="trx">TRON</option>
        <option value="doge">Dogecoin</option>
        <option value="bcc">Bitcoin Cash</option>
      </select>
    </div>

    <!-- Address & Copy -->
    <div class="bg-gray-50 rounded-lg p-4 border border-gray-200 mb-4 relative group cursor-pointer" id="addressBox">
      <p class="text-sm text-gray-700">Payment Address:</p>
      <p id="cryptoAddress" class="text-xs break-all font-mono text-blue-700 mt-2 select-all">
        Loading...
      </p>
      <span id="copyMsg" class="absolute top-2 right-2 text-xs text-green-500 hidden group-hover:block">Click to copy</span>
    </div>

    <!-- QR Code -->
    <div class="mb-4">
      <p class="text-sm text-gray-600 mb-2">Scan QR Code:</p>
      <div class="w-32 h-32 mx-auto bg-gray-100 rounded flex items-center justify-center" id="qrcode">
        <span class="text-gray-400 text-sm">QR</span>
      </div>
    </div>

    <p class="text-xs text-gray-500 mt-6">After we confirm the payment, you’ll be redirected automatically.</p>
  </div>

<script>
  const timerEl = document.getElementById('timer');
  const countdownKey = "cryptoCountdownEndTime";

  // Initialize or retrieve countdown end time
  let endTime = localStorage.getItem(countdownKey);
  if (!endTime) {
    const newEnd = new Date().getTime() + 15 * 60 * 1000; // 15 minutes
    localStorage.setItem(countdownKey, newEnd);
    endTime = newEnd;
  } else {
    endTime = parseInt(endTime, 10);
  }

  function updateTimer() {
    const now = new Date().getTime();
    const remaining = Math.max(0, endTime - now);
    const minutes = Math.floor(remaining / 1000 / 60);
    const seconds = Math.floor((remaining / 1000) % 60);
    timerEl.textContent = `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;

    if (remaining > 0) {
      requestAnimationFrame(updateTimer);
    } else {
      timerEl.textContent = "Time's up";
      localStorage.removeItem(countdownKey); // Reset for next time
    }
  }

  updateTimer();
</script>

  <script>
    

    // Wallet address & QR logic
    const cryptoSelect = document.getElementById('cryptoSelect');
    const addressDisplay = document.getElementById('cryptoAddress');
    const qrContainer = document.getElementById('qrcode');

    const cryptoAddresses = {
      btc: 'bc1qdha4kzxtkgzj5hgztwk0nea2jns9qrjaxmxagv',
      eth: '0x2E56AA4Accd289C52eD18c553F3fD717eC35CF8e',
      usdt: 'THLg82Lc2mj27GnAguy6AcWqXy2WBMxJoK',
      trx: 'THLg82Lc2mj27GnAguy6AcWqXy2WBMxJoK',
      doge: 'DTz8rqFApiw5BwtUJiFMDVm8NRN51GLZak',
      bcc: 'qpl05j6nrtezvpdkg7sdfclht35fd3jzev8c6nr3g0'
    };

    function updatePaymentInfo() {
      const selected = cryptoSelect.value;
      const address = cryptoAddresses[selected] || 'Unknown';
      addressDisplay.textContent = address;

      // Generate QR code
      QRCode.toCanvas(document.createElement('canvas'), address, { width: 128 }, function (err, canvas) {
        if (!err) {
          qrContainer.innerHTML = '';
          qrContainer.appendChild(canvas);
        }
      });
    }

    cryptoSelect.addEventListener('change', updatePaymentInfo);
    updatePaymentInfo(); // Init

    // Copy to clipboard
    document.getElementById('addressBox').addEventListener('click', () => {
      navigator.clipboard.writeText(addressDisplay.textContent)
        .then(() => {
          const msg = document.getElementById('copyMsg');
          msg.textContent = "Copied!";
          msg.classList.remove('hidden');
          setTimeout(() => {
            msg.textContent = "Click to copy";
          }, 2000);
        });
    });
  </script>

</body>
</html>
